/*
Opleiding	: Basisvaardigheden SQL Query's schrijven van SQLTeam.NL
Module		: Gegevens aggregeren
*/

/* Diverse aggregaties */
SELECT
	c.UserId			AS Gebruiker,
	COUNT(c.Id)			AS AantalComments,				-- Aantal records
	SUM(c.Score)		AS TotaleScore,					-- Som van de waarde
	AVG(c.Score)		AS GemiddeldeScorePerReactie,	-- Gemiddelde
	MIN(c.Score)		AS LaagsteScore,				-- Minimale waarde
	MAX(c.Score)		AS HoogsteScore					-- Maximale waarde
FROM dbo.Comments c
GROUP BY c.UserId
ORDER BY c.UserId

/* Filteren van aggregaties met HAVING functie */
SELECT
	c.UserId			AS Gebruiker,
	COUNT(c.Id)			AS AantalComments,
	SUM(c.Score)		AS TotaleScore,
	AVG(c.Score)		AS GemiddeldeScorePerReactie,
	MIN(c.Score)		AS LaagsteScore,
	MAX(c.Score)		AS HoogsteScore
FROM dbo.Comments c
-- WHERE c.UserId IS NOT NULL
GROUP BY c.UserId
HAVING COUNT(c.Id) > 100
ORDER BY c.UserId
-- Structuur van de query (plaats van HAVING functie)
